//
//  GSInterpolationFontProxy.h
//  GlyphsCore
//
//  Created by Georg Seifert on 02.06.15.
//  Copyright (c) 2015 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSFont.h>
@class GSFont;
@class GSGlyph;
@class GSInstance;
@class GSFontMaster;

NS_ASSUME_NONNULL_BEGIN

@interface GSInterpolationFontProxy : NSObject

- (instancetype)initWithFont:(GSFont *)font instance:(GSInstance *)instance error:(NSError **)error;
- (NSString *)fontMasterID;
- (nullable GSGlyph *)glyphForName:(NSString *)name;
- (nullable GSGlyph *)glyphForCharacter:(UTF32Char)aChar;
- (nullable GSGlyph *)glyphForName:(NSString *)name smartSettings:(nullable NSDictionary *)smartSettings;
- (GSFontMaster *)fontMasterForId:(NSString *)masterID;
- (void)resetCache;
- (void)loadRenameGlyphs;

@property (nullable, strong, nonatomic) GSFontMaster *fontMaster;

- (CGFloat)kerningForFontMasterID:(NSString *)fontMasterID firstGlyph:(GSGlyph *)firstGlyph secondGlyph:(GSGlyph *)secondGlyph direction:(GSWritingDirection)direction;

@end

NS_ASSUME_NONNULL_END
